﻿using Microsoft.Identity.Client;
using Newtonsoft.Json.Linq;
using System.Text;

var tokenEndpoint = "https://login.microsoftonline.com/tigplcb2cuat.onmicrosoft.com/oauth2/v2.0/token";
var integrationEndpoint = "https://ig-weu-uat-httpconnector-functions.azurewebsites.net/api/integration/track";
var clientId = "your-client-id";
var clientSecret = "your-client-secret";
var scope = "https://tigplcb2cuat.onmicrosoft.com/integration/.default"; 

// HTTP
var token = await GetBearerToken(tokenEndpoint, clientId, clientSecret, scope);
Console.WriteLine($"Bearer Token with Http call: {token}");

// ADAL (deprecated)
// var clientCredentials = new Microsoft.IdentityModel.Clients.ActiveDirectory.ClientCredential(clientId, clientSecret);
// var authContext = new AuthenticationContext(tokenEndpoint);
// token = authContext.AcquireTokenAsync(scope, clientCredentials).GetAwaiter().GetResult().AccessToken;
// Console.WriteLine($"Bearer Token with ADAL (deprecated): {token}");

// MSAL
var c = ConfidentialClientApplicationBuilder.Create(clientId)
    .WithClientSecret(clientSecret)
    .WithAuthority(new Uri(tokenEndpoint))
    .Build();
token = c.AcquireTokenForClient([scope]).ExecuteAsync().GetAwaiter().GetResult().AccessToken;
Console.WriteLine($"Bearer Token with MSAL: {token}");

await PostTrackingRequest(integrationEndpoint, token);

static async Task<string?> GetBearerToken(string tokenEndpoint, string clientId, string clientSecret, string scope)
{
    using var client = new HttpClient();
    var request = new HttpRequestMessage(HttpMethod.Post, tokenEndpoint);
    var keyValues = new[]
    {
        new KeyValuePair<string, string>("grant_type", "client_credentials"),
        new KeyValuePair<string, string>("client_id", clientId),
        new KeyValuePair<string, string>("client_secret", clientSecret),
        new KeyValuePair<string, string>("scope", scope)
    };

    request.Content = new FormUrlEncodedContent(keyValues);

    var response = await client.SendAsync(request);
    response.EnsureSuccessStatusCode();

    var responseContent = await response.Content.ReadAsStringAsync();
    var json = JObject.Parse(responseContent);
    return json["access_token"]?.ToString();
}

static async Task PostTrackingRequest(string url, string token)
{
    using var client = new HttpClient();
    client.DefaultRequestHeaders.Authorization = new System.Net.Http.Headers.AuthenticationHeaderValue("Bearer", token);

    var jsonContent = @"
    {
        ""search"": [
            {
                ""by"": ""id"",
                ""value"": [
                ""4D40C0DE-4FB6-48AD-9D3A-0ECF43F672E1""
                ]
            }
        ]
    }";

    var content = new StringContent(jsonContent, Encoding.UTF8, "application/json");
    var response = await client.PostAsync(url, content);
    response.EnsureSuccessStatusCode();

    var responseContent = await response.Content.ReadAsStringAsync();
    Console.WriteLine($"Tracking response: {responseContent}");
}